"""
RCSid:
	$Id: p3compat.py,v 1.6 2025/03/13 15:36:14 sjg Exp $

	@(#) Copyright (c) 2013 Simon J. Gerraty

	This file is provided in the hope that it will
	be of use.  There is absolutely NO WARRANTY.
	Permission to copy, redistribute or otherwise
	use this file is hereby granted provided that 
	the above copyright notice and this notice are
	left intact. 
      
	Please send copies of changes and bug-fixes to:
	sjg@crufty.net

"""

import sys

if sys.version_info[0] == 2:
    # b'str' and 'str' are equivalent
    # but not u'str'
    def b(s):
        if isinstance(s,unicode):
            return s.encode("latin-1")
        return s

    def s(b):
        if isinstance(b,unicode):
            return b.encode("latin-1")
        return b

else:
    # u'str' and 'str' are equivalent
    # but not b'str'
    def b(s):
        if isinstance(s,bytes):
            return s
        return s.encode("latin-1")

    def s(b):
        if isinstance(b,str):
            return b
        return b.decode("latin-1")

    def byte_array(b):
        if isinstance(b,str):
            return bytearray(b, "latin-1")
        return bytearray(b)
